#include "Arduino.h"
#include <DFPlayerMini_Fast.h>
#include <SoftwareSerial.h>
#include "Servo.h"

Servo myservo;

SoftwareSerial mySerial(3, 2);  // Defines where the RX and TX of the MP3-module are connected
int const trigPin = 11;
int const echoPin = 10;
int const LedPin = 13;
int sensorValue = 0;
int detectFace = 10;  // Distance in cm when the dance floor should activate

int LedState = LOW;

DFPlayerMini_Fast myMP3;  // Connect the library to the MP3 module, we can call the MP3-module later using this string

const int blinkDuration = 500;  // number of millisecs that LED's are off
const int LedInterval = 500;    // number of millisecs that LED's are on

// Variables

// create variables to hold the calculations for duration measured by Ultrasonic sensor and the distance calculated from that
float duration, distance;

bool songPlaying = false;  // Variable to check whether a song is already playing, used to prevent skipping when the code loops

unsigned long currentMillis = 0;      // stores the value of millis() in each iteration of loop()
unsigned long previousLedMillis = 0;  // will store last time the LED was updated

int pos = 0;

void setup() {
  Serial.begin(115200);
  mySerial.begin(9600);
  pinMode(trigPin, OUTPUT);
  pinMode(echoPin, INPUT);
  pinMode(LedPin, OUTPUT);
  myservo.attach(6);
  myMP3.volume(20);  // Set volume value. From 0 to 30
}

void loop() {

  currentMillis = millis();  // capture the latest value of millis(), used to calculate whether the LED's should blink or not to avoid using delay()

  digitalWrite(trigPin, LOW);
  delayMicroseconds(2);
  digitalWrite(trigPin, HIGH);
  delayMicroseconds(10);
  digitalWrite(trigPin, LOW);

  duration = pulseIn(echoPin, HIGH);

  distance = (duration * .0343) / 2;

  Serial.println("Afstand tot sensor");
  Serial.println(distance);  // Print de distance om te controleren dat de Ultrasonische sensor werkt

  playMusic();
  updateLEDs();
  switchLEDs();
}

void playMusic() {

  if (distance > 0) {
    if (distance < detectFace && (songPlaying == false)) {
      songPlaying = true;  // start playing song when face is detected
      myMP3.play(random(1, 5));
      delay(1000);
    } else if (distance < detectFace && (songPlaying == true)) {
      songPlaying = true;  // do nothing if these conditions are met, just keep playing the song
    } else if (distance > detectFace && (songPlaying == true)) {
      songPlaying = false;  // stop playing when face is pulled away
      myMP3.stop();
    }
  }
}

void updateLEDs() {
  if (LedState == LOW) {  // if the Led is off, wait for the LED Interval to pass before turning it on
    if (currentMillis - previousLedMillis >= LedInterval) {
      LedState = HIGH;
      previousLedMillis += LedInterval;  // save the time the change was made so the loop can run again
    }
  } else {
    if (currentMillis - previousLedMillis >= blinkDuration) {  // if the Led is on, wait for the blink duration to pass before turning it off
      LedState = LOW;
      previousLedMillis += blinkDuration;  // save the time the change was made so the loop can run again
    }
  }
}

void switchLEDs() {
  if (distance < detectFace) {
    digitalWrite(LedPin, LedState);
  } else {
    digitalWrite(LedPin, LOW);
  }
}